import { useMemo } from "react";

import { paths } from "@/routes/paths";
import SvgColor from "@/shared/components/svg-color";
import { useTranslate } from "@/locales";
import { Badge } from "@mui/material";
import Iconify from "@/shared/components/iconify/iconify";

// ----------------------------------------------------------------------

const icon = (name: string) => (
  <SvgColor
    src={`/assets/icons/navbar/${name}.svg`}
    sx={{ width: 1, height: 1 }}
  />
  // OR
  // <Iconify icon='fluent:mail-24-filled' />
  // https://icon-sets.iconify.design/solar/
  // https://www.streamlinehq.com/icons
);

const ICONS = {
  dashboard: <Iconify icon="solar:home-2-outline" />,
  agency: <Iconify icon="solar:buildings-2-outline" />,
  projects: <Iconify icon="solar:widget-6-outline" />,      
  tasks: <Iconify icon="solar:checklist-minimalistic-outline" />, 
  rewards: <Iconify icon="solar:medal-ribbons-star-outline" />,   

  folder: <Iconify icon="solar:folder-with-files-outline" />,
  calendar: <Iconify icon="solar:calendar-outline" />,

  user: <Iconify icon="solar:users-group-rounded-outline" />,  
  invoice: <Iconify icon="solar:bill-list-outline" />,
  manager: <Iconify icon="solar:user-rounded-outline" />,
  chat: <Iconify icon="solar:chat-round-dots-outline" />, 
};

// ----------------------------------------------------------------------

export function useNavData() {
  const role = localStorage.getItem("role");

  const { t } = useTranslate();

  const renderChatIcon = (
    <>
      {ICONS.chat}
      <Badge
        color="error"
        overlap="circular"
        badgeContent={9}
        anchorOrigin={{ vertical: "bottom", horizontal: "right" }}
        sx={{
          marginTop: -4,
          "& .MuiBadge-badge": {
            height: "16px",
            minWidth: "10px",
            fontSize: "0.7rem",
          },
        }}
      ></Badge>
    </>
  );

  let data;
  // -----------employee-----------------------------------------------------------

  data = useMemo(
    () => [
      // OVERVIEW
      {
        subheader: "Stunar",
        items: [
          {
            title: t("home"),
            path: paths.dashboard.root,
            icon: ICONS.dashboard,
          },
        ],
      },

      // ----------------------------------------------------------------------
  
      // MANAGEMENT
      {
        subheader: t("managemenent"),
        items: [
          // 2. Projets
          {
            title: "Project",
            path: paths.dashboard.projects.recent,
            icon: ICONS.projects,
            children: [
              {
                title: "Internal Projects",
                path: paths.dashboard.projects.internal,
              },
              {
                title: "External Projects",
                path: paths.dashboard.projects.external,
              },
            ],
          },
          
  
          // 3. MyTasks
          {
            title: "MyTasks",
            path: paths.dashboard.tasks.all_tasks,
            icon: ICONS.tasks,
          },

  
          // 4. Files manager
          {
            title: t("File manager"),
            path: paths.dashboard.filemanager.root,
            icon: ICONS.folder,
            children: [
              {
                title: "Personal Files",
                path: paths.dashboard.filemanager.personnalFiles,
              },
              {
                title: "Shared with me",
                path: paths.dashboard.filemanager.sharedWithMe,
              },
              {
                title: "Transfer File",
                path: paths.dashboard.transfer.root,
                children: [
                  { title: t("new"), path: paths.dashboard.transfer.new },
                  { title: t("list"), path: paths.dashboard.transfer.root },
                ],
              },
            ],
          },
  
          // 5. Calendrier
          {
            title: t("calendar"),
            path: paths.dashboard.calendar,
            icon: ICONS.calendar,
          },
  
          // 6. Équipes
          {
            title: "Teams",
            path: paths.dashboard.user.root,
            icon: ICONS.user,
          },
  
          // 7. Invoice
          {
            title: t("invoice"),
            path: paths.dashboard.invoice.root,
            icon: ICONS.invoice,
          },
  
          // 8. Rewards
          {
            title: t("rewards"),
            path: paths.dashboard.rewards.root,
            icon: ICONS.rewards,
            children: [
              {
                title: "List rewards",
                path: paths.dashboard.rewards.all_rewards,
              },
              {
                title: "List Winners",
                path: paths.dashboard.rewards.all_winners,
              },
            ],
          },
        ],
      },
    ],
    [t]
  );

  //----------------------client
  role == "client" &&
    (data = useMemo(
      () => [
        {
          subheader: "Stunar",
          items: [
            {
              title: t("home"),
              path: paths.dashboard.root,
              icon: ICONS.dashboard,
            },
            {
              title: t("workspace"),
              path: paths.dashboard.agency.list, // Parent path for the Agency section
              icon: ICONS.agency, // Change this icon as needed
            },
          ],
        },
        {
          subheader: t("managemenent"),
          
            items: [
              // 2. Projets
              {
                title: "Project",
                path: paths.dashboard.projects.root,
                icon: ICONS.projects,
                children: [
                  {
                    title: "Recent Projects",
                    path: paths.dashboard.projects.recent,
                  },
                  {
                    title: "Internal Projects",
                    path: paths.dashboard.projects.internal,
                  },
                  {
                    title: "External Projects",
                    path: paths.dashboard.projects.external,
                  },
                ],
              },
          
              // 3. MyTasks
              {
                title: "MyTasks",
                path: paths.dashboard.tasks.all_tasks,
                icon: ICONS.tasks,
              },
          
              // 4. Files manager
              {
                title: t("File manager"),
                path: paths.dashboard.filemanager.root,
                icon: ICONS.folder,
                children: [
                  {
                    title: "Personal Files",
                    path: paths.dashboard.filemanager.personnalFiles,
                  },
                  {
                    title: "Shared with me",
                    path: paths.dashboard.filemanager.sharedWithMe,
                  },
                  {
                    title: "Transfer File",
                    path: paths.dashboard.transfer.root,
                    children: [
                      { title: t("new"), path: paths.dashboard.transfer.new },
                      { title: t("list"), path: paths.dashboard.transfer.root },
                    ],
                  },
                ],
              },
          
              // 5. Calendrier
              {
                title: t("calendar"),
                path: paths.dashboard.calendar,
                icon: ICONS.calendar,
              },
          
              // 6. Équipes
              {
                title: "Teams",
                path: paths.dashboard.user.root,
                icon: ICONS.user,
              },
          
              // 7. Invoice
              {
                title: t("invoice"),
                path: paths.dashboard.invoice.root,
                icon: ICONS.invoice,
              },
          
              // 8. Rewards
              {
                title: t("rewards"),
                path: paths.dashboard.rewards.root,
                icon: ICONS.rewards,
                children: [
                  {
                    title: "List rewards",
                    path: paths.dashboard.rewards.all_rewards,
                  },
                  {
                    title: "List Winners",
                    path: paths.dashboard.rewards.all_winners,
                  },
                ],
              },
            ],
          },
        
      ],
      [t]
    ));

  role == "user" &&
    (data = useMemo(
      () => [
        {
          subheader: "Stunar",
          items: [
            {
              title: t("home"),
              path: paths.dashboard.root,
              icon: ICONS.dashboard,
            },
            {
              title: "workspace",
              path: paths.dashboard.agency.root, // Parent path for the Agency section
              icon: ICONS.agency, // Change this icon as needed
              children: [
                {
                  title: "Create",
                  path: paths.dashboard.agency.create, // Path for creating an agency
                },
                {
                  title: "List",
                  path: paths.dashboard.agency.list, // Path for listing agencies
                },
              ],
            },
          ],
        },
        {
          subheader: t("managemenent"),
          items: [
            {
              title: "Project ",
              path: paths.dashboard.projects.root,
              icon: ICONS.projects,
              children: [
                {
                  title: t("projects"),
                  path: paths.dashboard.projects.root,
                  children: [
                    {
                      title: "Create Project",
                      path: paths.dashboard.projects.add_project,
                    },
                    {
                      title: "List ",
                      path: paths.dashboard.projects.all_projects,
                    },
                  ],
                },
                {
                  title: "My Tasks",
                  path: paths.dashboard.tasks.all_tasks,
                  icon: ICONS.tasks,
                },
                {
                  title: t("rewards"),
                  path: paths.dashboard.rewards.all_rewards,
                  icon: ICONS.rewards,
                  children: [
                    {
                      title: "Create ",
                      path: paths.dashboard.rewards.add_reward,
                    },
                    {
                      title: "List rewards",
                      path: paths.dashboard.rewards.all_rewards,
                    },
                    {
                      title: "List Winners",
                      path: paths.dashboard.rewards.all_winners,
                    },
                  ],
                },
              ],
            },
            {
              title: t("invoice"),
              path: paths.dashboard.invoice.root,
              icon: ICONS.invoice,
            },
            {
              title: t("calendar"),
              path: paths.dashboard.calendar,
              icon: ICONS.calendar,
            },
            {
              title: "manager",
              path: paths.dashboard.manager,
              icon: ICONS.manager,
            },
          ],
        },
        {
          subheader: "File",
          items: [
            {
              title: t("File manager"),
              path: paths.dashboard.filemanager.root,
              icon: ICONS.folder,
              children: [
                {
                  title: "personal Files",
                  path: paths.dashboard.filemanager.personnalFiles,
                },
                {
                  title: "shared with me",
                  path: paths.dashboard.filemanager.sharedWithMe,
                },
                {
                  title: "shared files",
                  path: paths.dashboard.filemanager.sharedFiles,
                },
                {
                  title: "Transfer File",
                  path: paths.dashboard.transfer.root,
                  children: [
                    { title: t("new"), path: paths.dashboard.transfer.new },
                    { title: t("list"), path: paths.dashboard.transfer.root },
                  ],
                },
              ],
            }
          ],
        },
      ],
      [t]
    ));

  // user / admin
  (role == "user1" || role == "admin") &&
    (data = useMemo(
      () => [
        {
          subheader: "Stunar",
          items: [
            {
              title: t("home"),
              path: paths.dashboard.root,
              icon: ICONS.dashboard,
            },
            {
              title: t("workspace"),
              path: paths.dashboard.agency.root, // Parent path for the Agency section
              icon: ICONS.agency, // Change this icon as needed
              children: [
                {
                  title: "Create",
                  path: paths.dashboard.agency.create, // Path for creating an agency
                },
                {
                  title: "List",
                  path: paths.dashboard.agency.list, // Path for listing agencies
                },
              ],
            },
          ],
        },
        {
          subheader: t("managemenent"),
          items: [
            {
              title: t("calendar"),
              path: paths.dashboard.calendar,
              icon: ICONS.calendar,
            },
          ],
        
       
        },
      ],
      [t]
    ));

  return data;
}
