"use client";

import Container from "@mui/material/Container";

import { paths } from "@/routes/paths";

import { useSettingsContext } from "@/shared/components/settings";
import CustomBreadcrumbs from "@/components/custom-breadcrumbs";

import ProjectNewEditForm from "./project-new-edit-form";
import { Project } from "@/contexts/types/Project";

// ----------------------------------------------------------------------

export default function AddProjectView() {
  const settings = useSettingsContext();

  return (
    <Container maxWidth={settings.themeStretch ? false : "lg"}>
      <CustomBreadcrumbs
        heading="Create a new project"
        links={[
          {
            name: "Dashboard",
            href: paths.dashboard.root,
          },
          {
            name: "Project",
            href: paths.dashboard.projects.add_project,
          },

          {
            name: "New Project",
          },
        ]}
        sx={{
          mb: { xs: 3, md: 5 },
        }}
      />

      <ProjectNewEditForm />
    </Container>
  );
}
