import { useState, useCallback, useEffect } from "react";
import Stack from "@mui/material/Stack";
import Button from "@mui/material/Button";
import Avatar from "@mui/material/Avatar";
import Divider from "@mui/material/Divider";
import MenuItem from "@mui/material/MenuItem";
import Checkbox from "@mui/material/Checkbox";
import IconButton from "@mui/material/IconButton";
import Typography from "@mui/material/Typography";
import ListItemText from "@mui/material/ListItemText";
import { alpha, useTheme } from "@mui/material/styles";
import TableRow, { tableRowClasses } from "@mui/material/TableRow";
import TableCell, { tableCellClasses } from "@mui/material/TableCell";
import AvatarGroup, { avatarGroupClasses } from "@mui/material/AvatarGroup";
import { useBoolean } from "@/hooks/use-boolean";
import { useDoubleClick } from "@/hooks/use-double-click";
import { fDate, fTime } from "@/utils/format-time";
import Iconify from "@/shared/components/iconify";
import { useSnackbar } from "@/components/snackbar";
import { ConfirmDialog } from "@/components/custom-dialog";
import { IProjectItem, Project, collaborator } from "@/contexts/types/Project";
import Label from "@/components/label";
import CustomPopover, { usePopover } from "@/shared/components/custom-popover";
import { paths } from "@/routes/paths";
import { useRouter } from "@/hooks";
import { _Participants, _project } from "@/shared/_mock";
import { useGetCollaborators } from "@/shared/api/project";
// ----------------------------------------------------------------------

type Props = {
  row: Project;
};

export default function ProjectDeletedTableRow({ row }: Props) {
  const theme = useTheme();
  const {
    id,
    name,
    lastModification,
    type,
    status,
    startDate,
    endDate,
    collaboratorsIds,
  } = row;
  const { enqueueSnackbar } = useSnackbar();

  const details = useBoolean();

  const router = useRouter();
  const { collaborators } = useGetCollaborators();
  const [collaboratorData, setCollaboratorData] =
    useState<collaborator[]>(collaborators);

  useEffect(() => {
    if (collaborators.length) {
      setCollaboratorData(collaborators);
    }
  }, [collaborators]);
  const partcipants = collaboratorData.filter((participant: { id: number }) =>
    collaboratorsIds.includes(participant.id)
  );

  const handleClick = (id: any) => {
    // router.push(paths.dashboard.projects.project_details(id));
  };

  const defaultStyles = {
    borderTop: `solid 1px ${alpha(theme.palette.grey[500], 0.16)}`,
    borderBottom: `solid 1px ${alpha(theme.palette.grey[500], 0.16)}`,
    "&:first-of-type": {
      borderTopLeftRadius: 16,
      borderBottomLeftRadius: 16,
      borderLeft: `solid 1px ${alpha(theme.palette.grey[500], 0.16)}`,
    },
    "&:last-of-type": {
      borderTopRightRadius: 16,
      borderBottomRightRadius: 16,
      borderRight: `solid 1px ${alpha(theme.palette.grey[500], 0.16)}`,
    },
  };

  return (
    <>
      <>
        <TableRow
          sx={{
            borderRadius: 2,
            [`&.${tableRowClasses.selected}, &:hover`]: {
              backgroundColor: "background.paper",
              boxShadow: theme.customShadows.z20,
              transition: theme.transitions.create(
                ["background-color", "box-shadow"],
                {
                  duration: theme.transitions.duration.shortest,
                }
              ),
              "&:hover": {
                backgroundColor: "background.paper",
                boxShadow: theme.customShadows.z20,
              },
            },
            [`& .${tableCellClasses.root}`]: {
              ...defaultStyles,
            },
            ...(details.value && {
              [`& .${tableCellClasses.root}`]: {
                ...defaultStyles,
              },
            }),
          }}
        >
          <TableCell onClick={() => handleClick(row.id)}>
            <Stack direction="row" alignItems="center" spacing={2}>
              <Typography
                noWrap
                variant="inherit"
                sx={{
                  maxWidth: 200,
                  cursor: "pointer",
                  ...(details.value && { fontWeight: "fontWeightBold" }),
                }}
              >
                {name}
              </Typography>
            </Stack>
          </TableCell>
          <TableCell
            onClick={() => handleClick(row.id)}
            sx={{ whiteSpace: "nowrap" }}
          >
            <ListItemText
              primary={fDate(lastModification)}
              secondary={fTime(lastModification)}
              primaryTypographyProps={{ typography: "body2" }}
              secondaryTypographyProps={{
                mt: 0.5,
                component: "span",
                typography: "caption",
              }}
            />
          </TableCell>

          <TableCell
            onClick={() => handleClick(row.id.toString())}
            sx={{ whiteSpace: "nowrap" }}
          >
            {type}
          </TableCell>

          <TableCell
            onClick={() => handleClick(row.id)}
            sx={{ whiteSpace: "nowrap" }}
          >
            <Label
              variant="soft"
              color={
                (status === "IN_PROGRESS" && "warning") ||
                (status === "COMPLETED" && "success") ||
                (status === "PENDING" && "error") ||
                "default"
              }
            >
              {status}
            </Label>
          </TableCell>

          <TableCell
            onClick={() => handleClick(row.id)}
            sx={{ whiteSpace: "nowrap" }}
          >
            <ListItemText
              primary={fDate(startDate)}
              secondary={fTime(startDate)}
              primaryTypographyProps={{ typography: "body2" }}
              secondaryTypographyProps={{
                mt: 0.5,
                component: "span",
                typography: "caption",
              }}
            />
          </TableCell>
          <TableCell
            onClick={() => handleClick(row.id)}
            sx={{ whiteSpace: "nowrap" }}
          >
            <ListItemText
              primary={fDate(endDate)}
              primaryTypographyProps={{ typography: "body2" }}
              secondaryTypographyProps={{
                mt: 0.5,
                component: "span",
                typography: "caption",
              }}
            />
          </TableCell>

          <TableCell align="right" onClick={() => handleClick(row.id)}>
            <AvatarGroup
              max={4}
              sx={{
                display: "inline-flex",
                [`& .${avatarGroupClasses.avatar}`]: {
                  width: 24,
                  height: 24,
                  "&:first-of-type": {
                    fontSize: 12,
                  },
                },
              }}
            >
              {partcipants &&
                partcipants.map((person) => (
                  <Avatar alt={person.user.firstName}>
                    {person.user.firstName.charAt(0).toUpperCase()}
                  </Avatar>
                ))}
            </AvatarGroup>
          </TableCell>
        </TableRow>
      </>
    </>
  );
}
