import { Box, Button, Checkbox, Dialog, DialogActions, DialogContent, DialogProps, DialogTitle, Divider, FormGroup, InputAdornment, Stack, Switch, TextField, Typography } from "@mui/material";
import FormControl from '@mui/material/FormControl';
import ChatChannels from "./chat-channels";
import ChatHeaderCompose from "./chat-header-compose";
import { useGetContacts } from "@/shared/api/chat";
import { useCallback, useState } from "react";
import { IChatParticipant, IClient } from "@/shared/types/chat";
type Props = DialogProps & {
    //
    open: boolean;
    onClose: VoidFunction;
    type:string;
  };

export default function ChatAddToChannel({open,
    onClose,type,...other}:Props){
    
    const { contacts } = useGetContacts();

    const [recipients, setRecipients] = useState<IClient[]>([]);

    const handleAddRecipients = useCallback((selected: IClient[]) => {
        setRecipients(selected);
      }, []);
    return (
        <Dialog fullWidth maxWidth="xs" open={open} onClose={onClose} sx={{ overflow: 'hidden' }}>
        <DialogTitle >{type==='GROUP'?'Add members':'Add to channel '}</DialogTitle>

        <DialogContent sx={{ overflow: 'unset' }}>
            
            <FormControl>
                <FormGroup aria-label="position" row>
                    {type!='GROUP' ? 
                        <ChatChannels/>: 
                        <ChatHeaderCompose onAddRecipients={handleAddRecipients} >
                            <Typography variant="body2" sx={{ color: 'text.primary', mr: 2,my: 2 }}>
                                Members :
                            </Typography>
                        </ChatHeaderCompose>
                    }   
                </FormGroup> 
            </FormControl>           

        </DialogContent>

        <DialogActions sx={{ justifyContent: 'end' }}>

            <Button
                color="inherit"
                variant="contained"
            >
                Save changes
            </Button>
            <Button variant="outlined" color="inherit" onClick={onClose}>
                Close
            </Button>

        </DialogActions>
        </Dialog>
    );
}