
import Badge from '@mui/material/Badge';
import Avatar from '@mui/material/Avatar';
import MenuItem from '@mui/material/MenuItem';
import Typography from '@mui/material/Typography';
import ListItemText from '@mui/material/ListItemText';


import { _carouselsMembers, _contacts } from '@/shared/_mock';


// ----------------------------------------------------------------------

type Props = {
  children:React.ReactNode;
}
export default function ChatContacts({children}:Props) {

  return (
    <>
        <Typography variant="h6" sx={{ p: 1.5 }}>
          {children}
          Contacts <Typography component="span">({_carouselsMembers.length})</Typography>
        </Typography>

        {/* <Scrollbar sx={{ height: 1 }}> */}
          {_carouselsMembers.map((contact) => (
            <MenuItem key={contact.id} sx={{ p: 1 }}>
              <Badge
                // variant={contact.status as 'alway' | 'online' | 'busy' | 'offline'}
                anchorOrigin={{ vertical: 'bottom', horizontal: 'right' }}
                sx={{ mr: 2 }}
              >
                <Avatar alt={contact.name} src={contact.avatarUrl} />
              </Badge>

              <ListItemText
                primary={contact.name}
                primaryTypographyProps={{ typography: 'subtitle2' }}
                secondaryTypographyProps={{
                  typography: 'caption',
                  color: 'text.disabled',
                }}
              />
            </MenuItem>
          ))}
        {/* </Scrollbar> */}
    </>
  );
}
