import Grid from '@mui/material/Unstable_Grid2';

import { IFile, IFileManager, IFolderManager } from '@/shared/types/file';
import FileManagerFileItem from './file-manager-file-item';
import FileManagerFolderItem from './file-manager-folder-item';


type Props = {
  table: {
    selected: string[];
  };
  dataFiltered: IFile[];
  notFound:boolean;
  onOpenConfirm: VoidFunction;
  availableFolders?: { name: string; path: string }[];
  onDeleteItem: (id: string) => void;
  onToggleFavorite: (uniqueId: string, isFavorited: boolean) => Promise<boolean>;
  onRefresh?: VoidFunction;
  onOpenFolder? : (folderId: number, folderName: string) => void;
  onCopyLink?:(uniqueId:string)=>Promise<void>;

};

export default function FileManagerGridView({
  table,
  dataFiltered,
  onDeleteItem,
  availableFolders = [],
  onToggleFavorite,
  onRefresh,
  onOpenFolder
}: Props) {
  const getFileFormat = (fileName: string): string => {
    if (!fileName) return '';
    if (fileName === 'folder') return 'folder';
    const extension = fileName.split('.').pop()?.toLowerCase() || '';
    const typeMap: { [key: string]: string } = {
      pdf: 'pdf',
      doc: 'word',
      docx: 'word',
      xls: 'excel',
      xlsx: 'excel',
      ppt: 'ppt',
      pptx: 'ppt',
      txt: 'txt',
      jpg: 'jpg',
      jpeg: 'jpg',
      png: 'png',
      gif: 'gif',
      svg: 'svg',
      mp3: 'audio',
      wav: 'audio',
      mp4: 'video',
      avi: 'video',
      mov: 'video',
      zip: 'zip',
      rar: 'zip',
      ai: 'ai',
      psd: 'psd',
      esp: 'esp',
    };
  
    return typeMap[extension] || 'file';
  };

  return (
    <Grid container spacing={3}>
      {dataFiltered
        .filter((item) => item.type === 'folder')
        .map((folder) => (
          <Grid key={folder.id} xs={12} sm={6} md={4}>
            <FileManagerFolderItem
              folder={folder as IFolderManager}
              selected={table.selected.includes(folder.id)}
              onDelete={() => onDeleteItem(folder.id)}
              onToggleFavorite={onToggleFavorite}
              availableFolders={availableFolders}
              onRefresh={onRefresh}
              onOpenFolder={onOpenFolder}
              getFileFormat={getFileFormat}
              sx={{ maxWidth: 'auto' }}
            />
          </Grid>
        ))}

      {dataFiltered
        .filter((item) => item.type !== 'folder')
        .map((file) => (
          <Grid key={file.id} xs={12} sm={6} md={4}>
            <FileManagerFileItem
              file={file as IFileManager}
              selected={table.selected.includes(file.id)}
              onDelete={() => onDeleteItem(file.id)}
              onToggleFavorite={onToggleFavorite}
              availableFolders={availableFolders}
              onRefresh={onRefresh}
              getFileFormat={getFileFormat}
              sx={{ maxWidth: 'auto' }}
            />
          </Grid>
        ))}
    </Grid>
  );
}