import React from 'react';
import Button from '@mui/material/Button';
import { paths } from '@/routes/paths';
import RouterLink from '@/routes/router-link';
import Iconify from '@/shared/components/iconify';
import CustomBreadcrumbs from '@/shared/components/custom-breadcrumbs';

export default function InvoiceListHeader() {
  return (
    <CustomBreadcrumbs
      heading="List"
      links={[
        { name: 'Dashboard', href: paths.dashboard.root },
        { name: 'Invoice', href: paths.dashboard.invoice.root },
        { name: 'List' },
      ]}
      action={
        <Button
          component={RouterLink}
          sx={{
            backgroundColor: '#144dd5',
            '&:hover': {
              backgroundColor: '#144dd5',
            },
        
            textTransform: 'none',
            px: 2,
            marginLeft: 2,
          }}
          href={paths.dashboard.invoice.new}
          variant="contained"
          startIcon={<Iconify icon="mingcute:add-line" />}
        >
          New Invoice
        </Button>
      }
      sx={{ mb: { xs: 3, md: 5 } }}
    />
  );
}