import Table from '@mui/material/Table';
import Avatar from '@mui/material/Avatar';
import TableRow from '@mui/material/TableRow';
import TableCell from '@mui/material/TableCell';
import TableBody from '@mui/material/TableBody';
import CardHeader from '@mui/material/CardHeader';
import Card, { CardProps } from '@mui/material/Card';
import TableContainer from '@mui/material/TableContainer';

import { fCurrency, fPercent } from '@/utils/format-number';

import Label from '@/shared/components/label';
import Iconify from '@/shared/components/iconify';
import Scrollbar from '@/shared/components/scrollbar';
import { TableHeadCustom } from '@/shared/components/table';
import { LinearProgress } from '@mui/material';

// ----------------------------------------------------------------------

type RowProps = {
  id: string;
  name: string;

  rank: string;
  email: string;
  percent: number;
  avatarUrl: string;
  count: number;
};

interface Props extends CardProps {
  title?: string;
  subheader?: string;
  tableData: RowProps[];
  tableLabels: any;
}

export default function TeamWorkload({
  title,
  subheader,
  tableData,
  tableLabels,
  ...other
}: Props) {
  return (
   
      <><CardHeader title={title} subheader={subheader} sx={{ mb: 3 }} /><TableContainer sx={{ overflow: 'unset' }}>
      <Scrollbar>
        <Table sx={{ minWidth: 640 }}>
          <TableHeadCustom headLabel={tableLabels} />

          <TableBody>
            {tableData.map((row) => (
              <EcommerceBestSalesmanRow key={row.id} row={row} />
            ))}
          </TableBody>
        </Table>
      </Scrollbar>
    </TableContainer></>
 
  );
}

// ----------------------------------------------------------------------

type EcommerceBestSalesmanRowProps = {
  row: RowProps;
};


function EcommerceBestSalesmanRow({ row }: EcommerceBestSalesmanRowProps) {
  
  return (
    <TableRow>
      <TableCell sx={{ display: 'flex', alignItems: 'center', whiteSpace: 'nowrap' }}>
        <Avatar alt={row.name} src={row.avatarUrl} sx={{ mr: 2}} />
        {row.name}
      </TableCell>

      <TableCell >
        {fPercent(row.percent)}
        <LinearProgress
          variant="determinate"
          value={row.percent}
          color={
            row.percent >= 25
              ? 'error'
              : row.percent >= 40
              ? 'info'
              : row.percent >= 10
              ? 'warning'
              : 'primary'
          }
          sx={{
            width: '100%',
            mt: 1,
          }}
        />
      </TableCell>

     

      <TableCell align="right">{row.count} </TableCell>

      <TableCell align="right">
        <Label
          variant="soft"
          color={
            (row.rank === 'Top 1' && 'primary') ||
            (row.rank === 'Top 2' && 'info') ||
            (row.rank === 'Top 3' && 'success') ||
            (row.rank === 'Top 4' && 'warning') ||
            'error'
          }
        >
          {row.rank}
        </Label>
      </TableCell>
    </TableRow>
  );
}
