// ----------------------------------------------------------------------

export type ICalendarFilterValue = string[] | Date | null;

export type ICalendarFilters = {
  colors: string[];
  startDate: Date | null;
  endDate: Date | null;
};

// ----------------------------------------------------------------------

export type ICalendarDate = string | number | Date;

export type ICalendarView = 'dayGridMonth' | 'timeGridWeek' | 'timeGridDay' | 'listWeek';

export type ICalendarRange = {
  start: ICalendarDate;
  end: ICalendarDate;
} | null;

export type ICalendarEvent = {
  id: string;
  color: string;
  title: string;
  description: string;
  end: ICalendarDate;
  start: ICalendarDate;
  guests:string[];
  timeZone: string;
  notification:string;
  recurring:number;
  allDay?:boolean;
  textColor?:string;
};
export type ICalendarEventWithRecurrent = {
  id: string;
  color: string;
  title: string;
  description: string;
  end: Date;
  start: Date;
  guests:string[];
  timeZone: string; 
  notification:string;
  recurring:DialogData;
  allDay?:boolean;
  textColor?:string,
};

export const DAYS_NAME_OPTIONS = [
  { value: 'Monday', label: 'Monday' },
  { value: 'Tuesday', label: 'Tuesday' },
  { value: 'Wednesday', label: 'Wednesday' },
  { value: 'Thursday', label: 'Thursday' },
  { value: 'Friday', label: 'Friday' },
  { value: 'Saturday', label: 'Saturday' },
  { value: 'Sunday', label: 'Sunday' },
];


export const getDayOfWeek = (date: Date | null) => {
  if (!date) {
    return ''; 
  }
  const options: Intl.DateTimeFormatOptions = { weekday: 'long' };
  return new Intl.DateTimeFormat('fr-FR', options).format(date);
};

export const getDayOfWeekEng = (date: Date | null) => {
  if (!date) {
    return ''; 
  }
  const options: Intl.DateTimeFormatOptions = { weekday: 'long' };
  return new Intl.DateTimeFormat('en-EN', options).format(date);
};

export interface DialogData {
  id?:number;
  happens: string;
  every: number;
  selectedDays: string[];
  ends: string;
  selectedDate: Date | null;
  monthlyOptions: string;
  occurrences:number;
}