// ----------------------------------------------------------------------
export type IChatAttachment = {
  name: string;
  size: number;
  type: string;
  path: string;
  preview: string;
  createdAt: Date;
  modifiedAt: Date;
};

// export type IChatMessage = {
//   id: string;
//   body: string;
//   date: Date;
//   sourceUuid: string;
//   type: string;
//   destinationUuid: string
//   attachments: IChatAttachment[];
//   owner: IClient;
//   conversation: IChatConversationClient;
// };
export type IChatMessage = {
  id: number;
  uuid: string;
  createdAt: Date;
  date: Date;
  body: string;
  sourceUuid: string;
  type: string;
  destinationUuid: string | null;
  owner: IClient;
  update: boolean;
  reactions: IReactions[];
  pined: boolean;
  conversation: string;
  replyTo: IChatMessage | null;
  attachments: IChatAttachment[];
}

export type IReactions = {
  id: number;
  uuid: string;
  emoji: string;
}

export interface MessageType {
  sourceUuid: string;
  destinationUuid: string;
  type: string;
  body: string;
  date: Date;
  replyTo:  IChatMessage | null;
};

export type IChatParticipant = {
  id: string;
  name: string;
  role: string;
  email: string;
  address: string;
  avatarUrl: string;
  phoneNumber: string;
  lastActivity: Date;
  status: 'online' | 'offline' | 'alway' | 'busy';
};

export type IChatConversation = {
  id: string;
  type: string;
  name: string; //CHANGES
  unreadCount: number;
  messages: IChatMessage[];
  participants: IClient[];
};

// export type IChatConversations = {
//   byId: Record<string, IChatConversation>;
//   allIds: string[];
// };


////// Test avec backend ///////////

/***************************************************************************************************/

export interface IClient {
  id: number | string;
  uuid: string;
  firstname: string;
  lastname: string;
  username: string;
  usernameType: string;
  avatarUrl: string;
  phoneNumber: string;
  status: 'online' | 'offline';
  lastActivity: Date;
}

export type IChatConversationClient = {
  id: number;
  uuid: string;
   type: string;
   name: string;
  typeConv: string;
  messages: IChatMessage[];
  participants: IClient[];
  seenBy: IChatMessage[];
  owner: IClient;
  unreadCount: number;

};

export type IConversationClient = {

  typeConv: string;
  message: IChatMessage;
  recipient: IClient[];
  owner: IClient;
};

export type IChatMessageClient = {
  id: string;
  uuid: string;
  body: string;
  createdAt: Date;
  sourceUuid: string;
  type: string;
  attachments: IChatAttachment[];
};
export type IChatConversations = {
  byId: Record<string, IChatConversationClient>;
  allIds: string[];
};