export const getFileType = (type: string): 'IMAGE' | 'VIDEO' | 'AUDIO' | 'DOCUMENT' | null => {
    type = type.toUpperCase();
    
    if (type === 'IMAGE' || ['JPG', 'JPEG', 'PNG', 'GIF', 'SVG'].includes(type)) {
      return 'IMAGE';
    }
    if (type === 'VIDEO' || ['MP4', 'WEBM', 'OGV'].includes(type)) {
      return 'VIDEO';
    }
    if (type === 'AUDIO' || ['MP3', 'WAV', 'OGG'].includes(type)) {
      return 'AUDIO';
    }
    if (type === 'PDF' || ['DOC', 'DOCX', 'PDF','docx','doc','xlsx','xls','pptx','ppt'].includes(type)) {
      return 'DOCUMENT';
    }
    return null;
  };
  
  export const SUPPORTED_FILE_TYPES = ['IMAGE', 'VIDEO', 'AUDIO', 'PDF', 'DOCUMENT'];
  
  export const isOpenableFile = (type: string): boolean => {
    const fileType = getFileType(type);
    return fileType !== null;
  };