import { IInvoiceClient, IInvoiceManager } from '@/shared/types/invoice';

export function isIInvoiceClient(address: IInvoiceClient | IInvoiceManager): address is IInvoiceClient {
  return 'company' in address || 'name' in address || 'emailAddress' in address;
}

export function isIInvoiceManager(address: IInvoiceClient | IInvoiceManager): address is IInvoiceManager {
  return 'firstName' in address && 'lastName' in address && 'email' in address;
}