import { TokenPayload } from "@/shared/types/user";
import { jwtDecode } from "jwt-decode";


export const getTokenInfo = (token: string): TokenPayload => {
  try {
    const decodedToken = jwtDecode<TokenPayload>(token);
    const currentTime = Date.now() / 1000;
    const isValid = decodedToken.exp > currentTime;
    
    return {
      exp: decodedToken.exp,
      iat: decodedToken.iat,
      name: decodedToken.name,
      email: decodedToken.email,
      userId: decodedToken.userId,
      realm_access: {
        roles: decodedToken.realm_access.roles,
      },
      agency_role: decodedToken.agency_role || {},
      isValid,
    };
  } catch (error) {
    console.error("Error decoding token", error);
    return {
      exp: 0,
      iat: 0,        
      name: '',
      email: '',
      userId: '',
      realm_access: {
        roles: [],
      },
      agency_role: {},
      isValid: false,
    };
  }
};