import { _mock } from "./_mock";

// Participants (mock data for demonstration)
export const _Participants = [...Array(12)].map((_, index) => ({
  id: _mock.id(index),
  name: _mock.fullName(index),
  avatarUrl: _mock.image.avatar(index),
  phoneNumber: _mock.phoneNumber(index),
  email: _mock.email(index),
}));


const shared = (index: number) =>
  (index === 0 && _Participants.slice(3, 5)) ||
  (index === 1 && _Participants.slice(5, 9)) ||
  (index === 2 && _Participants.slice(9, 11)) ||
  (index === 3 && _Participants.slice(3, 9)) ||
  _Participants.slice(0, 5); // Default slice

// Agency names
const AgencyNames = [
  "Express Cargo", "Global Logistics", "Speedy Shipments", "Freight Forwarders Inc.",
  "Swift Transport", "Cargo Masters", "Fast Freight", "Quick Ship", "Transit Solutions",
  "Rapid Logistics", "Ship It Now", "Air Express", "Oceanic Freight", "Delivery Experts",
  "Borderless Logistics", "Priority Cargo", "Express Delivery", "Trusted Transfers",
  "Global Express", "Reliable Shipping"
];

export const _agency = [...Array(20)].map((_, index) => ({
  id: _mock.id(index),
  name: AgencyNames[index],
  email: `agency${index}@example.com`,
  phoneNumber: _mock.phoneNumber(index),
  users: [], // Add empty array or actual user mock data
  participants: shared(index),
  createDate: _mock.time(index),
  description: `A description of the agency ${AgencyNames[index]}`,
  address: {
    primaryAddresse: "123 Main St",
    optionalAddress: "Suite 200",
    city: "Anytown",
    country: "USA",
    postalCode: "12345",
  },
  currency: "USD",
  status: "VALIDATED",
  picture: _mock.image.avatar(index),
  agencyName: AgencyNames[index],
}));
