import React from 'react';
import EmojiPicker, { EmojiClickData } from 'emoji-picker-react';

interface EmojiPickerProps {
  onEmojiClick: (emojiData: EmojiClickData, event: MouseEvent) => void;
}

const CustomEmojiPicker: React.FC<EmojiPickerProps> = ({ onEmojiClick }) => {
  const pickerStyle = {
    
    width: '100%',  // Change this value to the desired width
    height: '300px', // Change this value to the desired height
  };

  return <EmojiPicker onEmojiClick={onEmojiClick} style={pickerStyle} />;
};

export default CustomEmojiPicker;
