import { IAgencyTableFilterValue, IAgencyTableFilters } from "@/shared/types/agency";
import Box from "@mui/material/Box";
import Chip from "@mui/material/Chip";
import Paper from '@mui/material/Paper';
import Stack, { StackProps } from '@mui/material/Stack';
import { useCallback } from "react";


type Props = StackProps & {
    filters: IAgencyTableFilters;
    onFilters: (name: string, value: IAgencyTableFilterValue) => void;
    //
    onResetFilters: VoidFunction;
    //
    results: number;
  };

export default function AgencyTableFiltresResult({

 filters,
  onFilters,
  //
  onResetFilters,
  //
  results,
  ...other
}: Props)
{

    const handleRemoveKeyword = useCallback(() => {
        onFilters('name', '');
      }, [onFilters]);



      //return 
      return (
        <Stack spacing={1.5} {...other}>
      <Box sx={{ typography: 'body2' }}>
        <strong>{results}</strong>
        <Box component="span" sx={{ color: 'text.secondary', ml: 0.25 }}>
          results found
        </Box>
      </Box>
      <Stack flexGrow={1} spacing={1} direction="row" flexWrap="wrap" alignItems="center">
      {!!filters.name && (
          <Block label="Keyword:">
            <Chip label={filters.name} size="small" onDelete={handleRemoveKeyword} />
          </Block>
        )}
      </Stack>
      </Stack>
      )
}
//

type BlockProps = StackProps & {
    label: string;
  };
  
function Block({ label, children, sx, ...other }: BlockProps) {
    return (
      <Stack
        component={Paper}
        variant="outlined"
        spacing={1}
        direction="row"
        sx={{
          p: 1,
          borderRadius: 1,
          overflow: 'hidden',
          borderStyle: 'dashed',
          ...sx,
        }}
        {...other}
      >
        <Box component="span" sx={{ typography: 'subtitle2' }}>
          {label}
        </Box>
  
        <Stack spacing={1} direction="row" flexWrap="wrap">
          {children}
        </Stack>
      </Stack>
    );
}