"use client";

import Box from "@mui/material/Box";
import { alpha } from "@mui/material/styles";
import Container from "@mui/material/Container";
import Typography from "@mui/material/Typography";
import Button from "@mui/material/Button";
import { paths } from "@/routes/paths";
import { useSettingsContext } from "@/shared/components/settings";
import CustomBreadcrumbs from "@/components/custom-breadcrumbs";
import RouterLink from "@/routes/router-link";
import Iconify from "@/shared/components/iconify";
import AllTasksView from "./task-list-view";
import { useCallback, useState } from "react";
import { Stack, Tab, Tabs } from "@mui/material";
import TaskArchivedList from "./task-archived-list";
import TaskFavoriteList from "./task-favorite-list";
import TaskDeletedList from "./task-deleted-list";
// ----------------------------------------------------------------------

export default function TasksView() {
  const settings = useSettingsContext();

  const [currentTab, setCurrentTab] = useState("current");

  const handleChangeTab = useCallback(
    (event: React.SyntheticEvent, newValue: string) => {
      setCurrentTab(newValue);
    },
    []
  );

  const TABS = [
    {
      value: "current",
      label: "Current",
      icon: <Iconify icon="fluent:clipboard-task-list-24-filled" width={24} />,
    },
    {
      value: "favorite",
      label: "Favorite",
      icon: <Iconify icon="mdi:favorite-shooting" width={24} />,
    },
    {
      value: "archived",
      label: "Archived",
      icon: (
        <Iconify
          icon="solar:archive-down-minimlistic-bold-duotone"
          width={24}
        />
      ),
    },

    {
      value: "deleted",
      label: "Deleted",
      icon: <Iconify icon="ic:round-delete-sweep" width={24} />,
    },
  ];

  return (
    <Container maxWidth={settings.themeStretch ? false : "lg"}>
      {/* <CustomBreadcrumbs
        heading="List"
        links={[
          {
            name: "Dashboard",
            href: paths.dashboard.root,
          },
          {
            name: "Tasks",
            href: paths.dashboard.tasks.all_tasks,
          },
          {
            name: "List",
          },
        ]}
        action={
          
        }
        sx={{
          mb: { xs: 3, md: 5 },
        }}
        /> */}
      <Stack spacing={2} justifyContent="space-between" direction={"row"}>
        <Tabs
          value={currentTab}
          onChange={handleChangeTab}
          sx={{
            mb: { xs: 3, md: 5 },
          }}
        >
          {TABS.map((tab) => (
            <Tab
              key={tab.value}
              label={tab.label}
              icon={tab.icon}
              value={tab.value}
            />
          ))}
        </Tabs>
      </Stack>
      {currentTab === "current" && <AllTasksView />}
      {currentTab === "archived" && <TaskArchivedList />}
      {currentTab === "favorite" && <TaskFavoriteList />}
      {currentTab === "deleted" && <TaskDeletedList />}
    </Container>
  );
}
