import Avatar from '@mui/material/Avatar';
import Typography from '@mui/material/Typography';
import ListItemButton from '@mui/material/ListItemButton';

import SearchNotFound from '@/shared/components/search-not-found';

import { IChatParticipant, IClient } from '@/shared/types/chat';

// ----------------------------------------------------------------------

type Props = {
  query: string;
  results: IClient[];
  onClickResult: (contact: IClient) => void;
};

export default function ChatNavSearchResults({ query, results, onClickResult }: Props) {
  const totalResults = results.length;

  const notFound = !totalResults && !!query;

  return (
    <>
      <Typography
        variant="h6"
        sx={{
          px: 2.5,
          mb: 2,
        }}
      >
        Contacts ({totalResults})
      </Typography>

      {notFound ? (
        <SearchNotFound
          query={query}
          sx={{
            p: 3,
            mx: 'auto',
            width: `calc(100% - 40px)`,
            bgcolor: 'background.neutral',
          }}
        />
      ) : (
        <>
          {results.map((result) => (
            <ListItemButton
              key={result.id}
              onClick={() => onClickResult(result)}
              sx={{
                px: 2.5,
                py: 1.5,
                typography: 'subtitle2',
              }}
            >
              <Avatar alt={result.firstname} src={result.avatarUrl} sx={{ mr: 2 }} />
              {result.firstname}
            </ListItemButton>
          ))}
        </>
      )}
    </>
  );
}
