import Iconify from "@/shared/components/iconify";
import { Box, Button, Checkbox, Dialog, DialogActions, DialogContent, DialogProps, DialogTitle, Divider, FormGroup, InputAdornment, Stack, Switch, TextField, Typography } from "@mui/material";
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import FormControl from '@mui/material/FormControl';
import FormLabel from '@mui/material/FormLabel';
import { useCallback, useState } from "react";
import ChatHeaderCompose from "./chat-header-compose";
import { IChatParticipant, IClient } from "@/shared/types/chat";
import { useGetContacts } from "@/shared/api/chat";
type Props = DialogProps & {
    //
    open: boolean;
    onClose: VoidFunction;
  };
interface CheckedStates {
[key: string]: boolean;
}
export default function ChatNotifications({open,
    onClose,...other}:Props){
    
    const [directvalue, setDirectvalue] = useState('all');

    const [teamValue, setTeamValue] = useState('all');

    const [clientValue, setClientValue] = useState('all');

    const { contacts } = useGetContacts();

    const [recipients, setRecipients] = useState<IClient[]>([]);


    const handleAddRecipients = useCallback((selected: IClient[]) => {
        setRecipients(selected);
      }, []);

    const handleChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        setDirectvalue((event.target as HTMLInputElement).value);
    };

    const handleTeamChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        setTeamValue((event.target as HTMLInputElement).value);
    };

    const handleClientChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        setClientValue((event.target as HTMLInputElement).value);
    };

    const [allNotifschecked, setAllNotifsChecked] = useState(true);

    const handleChangeNotifsAllNotifs = (event: React.ChangeEvent<HTMLInputElement>) => {
        setAllNotifsChecked(event.target.checked);
    };

    const [categNotifschecked, setCategNotifsChecked] = useState<CheckedStates>({ 'All direct messages': false, 'All channels': false});

    const handleChangeNotifsByCateg = (event: React.ChangeEvent<HTMLInputElement>) => {
        const { name, checked } = event.target;
        if (name in categNotifschecked) {
            setCategNotifsChecked(prev => ({ ...prev, [name]: checked }));
        }
      };
    return (
        <Dialog fullWidth maxWidth="xs" open={open} onClose={onClose} sx={{ overflow: 'hidden' }}>
        <DialogTitle >Message notifications </DialogTitle>

        <DialogContent sx={{ overflow: 'unset' }}>
            
            <FormControl>
                <FormGroup aria-label="position" row>
                    
                    <FormControlLabel
                    value="allNotifications"
                    control={<Switch
                        checked={allNotifschecked}
                        onChange={handleChangeNotifsAllNotifs}
                        name="allNotifschecked"
                    />}
                    label="Activate all"
                    labelPlacement="end"
                    
                    />
                </FormGroup>
            </FormControl>
            { categNotifschecked['Direct'] && directvalue==='chooseContacts' && 
            (<>
                <Divider sx={{ my: 2 }} /><ChatHeaderCompose  onAddRecipients={handleAddRecipients}>
                <Typography variant="body2" sx={{ color: 'text.primary', mr: 2, my: 2 }}>
                    Contacts :
                </Typography>
                </ChatHeaderCompose>
            </>)}
            { categNotifschecked['Channel'] && teamValue==='chooseContacts' && 
            (<>
                <ChatHeaderCompose  onAddRecipients={handleAddRecipients}>
                <Typography variant="body2" sx={{ color: 'text.primary', mr: 2, my: 2 }}>
                    Channels :
                </Typography>
                </ChatHeaderCompose>
            </>)}
            

        </DialogContent>

        <DialogActions sx={{ justifyContent: 'end' }}>
            <Button
                color="inherit"
                variant="contained"
                onClick={onClose}
            >
                Save
            </Button>
            <Button variant="outlined" color="inherit" onClick={onClose}>
                Close
            </Button>

        </DialogActions>
        </Dialog>
    );
}