declare module '@marketingconfort/mc-chat-front' {
    import { FC } from 'react';

    export interface ChatTheme {
        colors: {
            primary: string;
            secondary: string;
            background: string;
            font: string;
        };
    }

    export interface EnvUrls {
        hostApi: string;
        chatWs: string;
        awsBucket: string;
        clientUserServiceUrl: string;
    }

    export interface ChatAppProps {
        theme?: ChatTheme;
        envUrls?: EnvUrls;
    }

    const App: FC<ChatAppProps>;

    export { ChatTheme };
    export { EnvUrls };

    export default App;
}