'use client';

import { GuestGuard } from '@/contexts/auth/guard';
import AuthClassicLayout from '@/shared/layouts/auth/classic';

// ----------------------------------------------------------------------

type Props = {
  children: React.ReactNode;
};

export default function Layout({ children }: Props) {
  return (
    <GuestGuard>
      <AuthClassicLayout title="Manage the job more effectively with Stunar">
        {children}
      </AuthClassicLayout>
    </GuestGuard>
  );
}
