'use client';

import { AuthGuard } from '@/contexts/auth/guard';
import DashboardLayout from '@/shared/layouts/dashboard';
import { LocalizationProvider } from '@mui/x-date-pickers';
import Chat from '@marketingconfort/mc-chat-front';
import { Box } from '@mui/material';

// ----------------------------------------------------------------------

type Props = {
  children: React.ReactNode;
};

const customTheme = {
  colors: {
    primary: '#f0f5ff',
    secondary: '#144dd5',
    background: '#ffffff',
    font: '#212529'
  }
};

const envUrls = {
  hostApi: process.env.NEXT_PUBLIC_CHAT_HOST_API || '',
  chatWs: process.env.NEXT_PUBLIC_CHAT_WS || '',
  awsBucket: process.env.NEXT_PUBLIC_AWS_BUCKET || '',
  clientUserServiceUrl: process.env.NEXT_PUBLIC_CLIENT_USER_SERVICE_URL || '',
};

export default function Layout({ children }: Props) {
  return (
    <AuthGuard>
      <LocalizationProvider>
        <DashboardLayout>{children}</DashboardLayout>
        <Box sx={{
          position: 'fixed',
          top: 0,
          right: 0,
          bottom: 0,
          zIndex: 1200,
          pointerEvents: 'none',
          '& > *': {
            pointerEvents: 'auto'
          }
        }}>
          <Chat theme={customTheme} envUrls={envUrls} />
        </Box>
      </LocalizationProvider>
    </AuthGuard>
  );
}
