import { IUserItem } from "@/shared/types/user";
import { ITaskItem } from "./tasks";

// ----------------------------------------------------------------------
export type IProjectItem = {
  id: string;
  title: string;
  description: string;
  StartDate: Date;
  EndDate: Date;
  status: string;
  type: string;
  Participants: Participants[];
  tasks: ITaskItem[];
  isFavorited: boolean;

  isDeleted: boolean;
  isArchived: boolean;
  DeletedAt: Date;
  DeletedBy: Participants;
};
export type Participants = {
  id: number;
  name: string;
  avatarUrl: string;
  phoneNumber: string;
  email: string;
};

export type collaborator = {
  id: number;
  successCount: number | null;
  user: {
    firstName: string;
    lastName: string;
    email: string;
    phoneNumber: string;
  };
};

export type IProjectFilterValue = string | string[] | Date | null;

export type IProjectFilters = {
  name: string;
  status: string;
  type: string[];
  startDate: Date | null;
  endDate: Date | null;
};

export type IProject = {
  description?: string | undefined;
  startDate?: Date | undefined;
  endDate?: any;
  status?: string | undefined;
  name: string;
  type: string;
  collaboratorsIds?: number[] | undefined;
};

export type Project = {
  id: number;
  name: string;
  startDate: Date; // ISO string format for LocalDateTime
  endDate: Date; // ISO string format for LocalDateTime
  description?: string;
  type: string;
  status: string;
  itemState: string;
  lastModification: Date; // ISO string format for LocalDateTime
  tasks: ITaskItem[];
  responsibleId?: number;
  collaboratorsIds: number[];
  clientId?: number;
  agencyId?: number;
};


export type ProjectOverviewStatsType = {
  completedTaskCount: number;
  recentlyUpdatedTaskCount: number;
  newTaskCount: number;
  dueTaskCount: number;
}

export type TaskDistributionStatsType = {
  bugCount: number;
  featureCount: number;
}

export type TeamWorkloadStatsType = {
  userId: string;
  username: string;
  assignedTaskCount: number;
}
