import { useState, useCallback } from 'react';
import { transferApi } from '@/shared/api/transfer-file';
import { ITransfer } from '@/shared/types/transfer';

export function useTransfers() {
    const [transfers, setTransfers] = useState<ITransfer[]>([]);
    const [loading, setLoading] = useState(false);
    const [error, setError] = useState<string | null>(null);

    const getTransfers = useCallback(async () => {
        try {
            setLoading(true);
            const response = await transferApi.getAllTransfers();
            
            // Formatage des données
            const formattedData = response.map((item: any) => ({
                id: item.id,
                title: item.title,
                expirationDate: new Date(item.expirationDate), 
                status: item.status.toLowerCase(),
            }));
            
            setTransfers(formattedData);
        } catch (err) {
            console.error('Error fetching transfers:', err);
            setError(err instanceof Error ? err.message : 'Failed to fetch transfers');
        } finally {
            setLoading(false);
        }
    }, []);

    return {
        transfers,
        loading,
        error,
        getTransfers,
    };
}