import axios, { AxiosRequestConfig } from 'axios';
import { comment } from 'postcss';


export const HOST_API = 'http://localhost:4000';

export const axiosInstance = axios.create({ baseURL: HOST_API });

axiosInstance.interceptors.response.use(
    (res) => res,
    (error) => Promise.reject((error.response && error.response.data) || 'Something went wrong')
);

export default axiosInstance;

export const fetcher = async (args: string | [string, AxiosRequestConfig]) => {
    const [url, config] = Array.isArray(args) ? args : [args];

    const res = await axiosInstance.get(url, { ...config });

    return res.data;
};


// export const endpoints = {
//     comments: {
//       add: "/chat/message",
//       get: (liveId:string) =>`/chat/stream/${liveId}`,
//     },
//     product: "/product",
//     live : {
//       stream: '/live',
//       products : '/live-product',
//       stats : {
//         summaryAll : '/api/stats/summary',
//         summary : (liveId:string) => `/api/stats/${liveId}/summary`,
//         realTime : (keyStream:string) => `/api/stats/${keyStream}`,
//       }
//     },
//   };