import Iconify from "@/shared/components/iconify/iconify";
import { IAgencyTableFilters, IAgencyTableFilterValue } from "@/shared/types/agency";
import InputAdornment from "@mui/material/InputAdornment";
import Stack from "@mui/material/Stack";
import TextField from "@mui/material/TextField";
import { useCallback } from "react";
import { SxProps, Theme } from '@mui/material';
import { alpha } from '@mui/material/styles';

// on definit it props avec la précision des types de propreties de props
type Props = {
    filters: IAgencyTableFilters;
    onFilters: (name: string, value: IAgencyTableFilterValue) => void;
    sx?: SxProps<Theme>;
}

export default function AgencyTableToolbar({
        filters,
        onFilters,
        sx
    }: Props)

{

const handleFilterName = useCallback(
    (event: React.ChangeEvent<HTMLInputElement>) => {
      onFilters('name', event.target.value);
    },
    [onFilters]
  );
//

  //
  return (
    <Stack 
      spacing={2} 
      alignItems={{ xs: 'flex-end', md: 'center' }} 
      direction={{ xs: 'column', md: 'row' }}
      sx={{ 
        p: 2.5, 
        pr: { xs: 2.5, md: 1 },
        ...sx
      }}
    >
      <TextField
        fullWidth
        value={filters.name}
        onChange={handleFilterName}
        placeholder="Search name agency..."
        InputProps={{
          startAdornment: (
            <InputAdornment position="start">
              <Iconify icon="eva:search-fill" sx={{ color: 'text.disabled' }} />
            </InputAdornment>
          ),
        }}
        sx={{ 
          maxWidth: { md: 280 },
          boxShadow: (theme) => theme.shadows[1],
          '& .MuiOutlinedInput-root': {
            '& fieldset': {
              borderWidth: '1px !important',
              borderColor: (theme) => alpha(theme.palette.grey[500], 0.16),
            },
          },
        }}
      />
    </Stack>
  )
}